/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.provider.pi.PIHscProviderConstants;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class PIConcMaintDiscardHandler {
    private static final int SUCCESS = 0;
    private static final int FAIL = 1;
    private static final String DISCARD_REMAINING_RESP_DATA = "DISCARD_REMAINING_RESP_DATA";
    private String m_cecName;

    public PIConcMaintDiscardHandler(String string) {
        this.m_cecName = string;
    }

    public int handleUnknownHypPipeResponse(int n, Hashtable hashtable) {
        System.out.println("handling/discarding data from unknown response!");
        FSPCmdMgr fSPCmdMgr = null;
        Hashtable hashtable2 = null;
        UnsignedInt32 unsignedInt32 = this.findKeyID(hashtable);
        if (unsignedInt32 != null) {
            fSPCmdMgr = OmCecMgr.getCecMgr(this.m_cecName).getCmdMgr();
            try {
                hashtable2 = fSPCmdMgr.doFSPCommand(DISCARD_REMAINING_RESP_DATA, new String[]{unsignedInt32.toString()});
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.out.println("Could not discard remaining response data!");
                return 1;
            }
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable2.get("RETURN_CODE");
            if (PIHscProviderConstants.IO_CON_MAIN_SUCCESS == unsignedInt16) {
                return 0;
            }
            System.out.println("Discard remaining resp. data call failed!");
            return 1;
        }
        return 0;
    }

    private UnsignedInt32 findKeyID(Hashtable hashtable) {
        UnsignedInt32 unsignedInt32 = null;
        if (hashtable != null) {
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable.get("RETURN_CODE");
            System.out.println("HypPipeResponse return code: " + unsignedInt16);
            if (PIHscProviderConstants.IO_CON_MAIN_SUCCESS == unsignedInt16) {
                long l = ((UnsignedInt32)hashtable.get("LENGTH3")).longValue();
                System.out.println("Lenth of remaining data: " + l);
                if (l > 0L) {
                    unsignedInt32 = (UnsignedInt32)hashtable.get("KEY_ID");
                    System.out.println("Key ID: " + unsignedInt32);
                }
            }
        }
        return unsignedInt32;
    }
}

